class ConfirmDialog {
    /**
     * @param {string} message
     */
    constructor(message) {
        this.dialog = document.querySelector('#confirm-dialog');
        this.dialog.querySelector('p').textContent = message;
        this.dialog.onclose = (event) => {
            this.dialog.returnValue = event.target.returnValue;
        };
    }

    async showModal() {
        return new Promise((resolve) => {
            this.dialog.onclose = (event) => {
                resolve(event.target.returnValue);
            };
            this.dialog.showModal();
        });
    }
}
