const loadMediaItems = (appId, userId) => {
    const mediaItems = [
        {
            url: "https://sample.playnplay.com/video/sintel-1280-surround.mp4",
            subtitles: [{
                url: "https://sample.playnplay.com/video/sintel_en.vtt",
                language: "en",
                label: "English",
                mode: "autoSelect",
            }],
            metadata: {
                artworkUrl: "https://upload.wikimedia.org/wikipedia/commons/8/8f/Sintel_poster.jpg",
                downloadPath: "/Blender/Non-DRM/Sintel (자막)",
            },
        },
        {
            url: "https://sample.playnplay.com/video/big_buck_bunny.mp4",
        },
        {
            url: "https://sample.playnplay.com/video/big_buck_bunny.mp4.drm",
        },
        {
            url: "https://sample.playnplay.com/video/4K_HDR_video.mp4",
        },
    ].map((mediaItem) => {
        return {
            ...mediaItem,
            drm: {
                appId,
                userId,
            }
        };
    });
    return mediaItems;
};