class Playlist {
    /**
     * @param {MediaItem[]} mediaItems 
     */
    constructor(mediaItems) {
        this._mediaItems = mediaItems;
        this._currentIndex = -1;
    }

    /**
     * @returns {MediaItem[]}
     */
    get mediaItems() {
        return this._mediaItems;
    }

    /**
     * @returns {MediaItem}
     */
    get currentItem() {
        return this._mediaItems[this._currentIndex];
    }

    /**
     * @returns {number}
     */
    get currentIndex() {
        return this._currentIndex;
    }

    /**
     * @returns {boolean}
     */
    get hasNext() {
        return this._currentIndex < this._mediaItems.length - 1;
    }

    /**
     * @returns {boolean}
     */
    get hasPrevious() {
        return this._currentIndex > 0;
    }

    /**
     * @param {number} index 
     * @param {(MediaItem, number) => void} callback 
     */
    moveToIndex(index, callback) {
        if (index < 0 || index >= this.mediaItems.length) {
            return;
        }
        if (this._currentIndex === index) {
            return;
        }
        this._currentIndex = index;
        callback(this._mediaItems[index], this._currentIndex);
    }

    /**
     * @param {(MediaItem, number) => void} callback 
     */
    moveToNext(callback) {
        if (this.hasNext) {
            this._currentIndex += 1;
            callback(this._mediaItems[this._currentIndex], this._currentIndex);
        }
    }

    /**
     * @param {(MediaItem, number) => void} callback 
     */
    moveToPrevious(callback) {
        if (this.hasPrevious) {
            this._currentIndex -= 1;
            callback(this._mediaItems[this._currentIndex, this._currentIndex]);
        }
    }
}
